document.addEventListener('DOMContentLoaded', function () {
  const toggleBtn = document.querySelector('.filters-toggle');
  const filters = document.querySelector('.filters-container');

  if (toggleBtn && filters) {
    toggleBtn.addEventListener('click', () => {
      filters.classList.toggle('active');
      toggleBtn.classList.toggle('active');

      const text = toggleBtn.querySelector('span');
      text.textContent = filters.classList.contains('active')
        ? 'Hide Filters'
        : 'Show Filters';
    });
  }
  const cards = document.querySelectorAll('.card-preview');
  
  cards.forEach(card => {
    const line = card.querySelector('.line-hor');
    const title = card.querySelector('.property-loc');

    if (!line || !title) return;

    card.addEventListener('mouseenter', () => {
      const titleWidth = title.offsetWidth;

      line.style.transition = 'width 0.3s ease';
      line.style.width = `${titleWidth}px`;
      line.style.display = 'block';
      line.style.backgroundColor = 'var(--line-color)';
      line.style.transformOrigin = 'left';
      line.style.marginLeft = '0';
    });

    card.addEventListener('mouseleave', () => {
      line.style.width = '100%';
    });
    card.addEventListener('click', function() {
        let baseUrl = window.location.origin + window.location.pathname;
        const reference = card.dataset.ref
        window.location.href = baseUrl + reference;
    }  
  )
    const areaSelect = document.getElementById("area");

    // Inicializar Select2 sin jQuery
    if (window.Select2) {
      new Select2(areaSelect, {
        placeholder: "Select area",
        closeOnSelect: false,
        width: "100%"
      });
    }
  });
  const btnSelect = document.getElementById('btnSelect');
  const btnDeselect = document.getElementById('btnDeselect');
  const dropdowns = document.querySelectorAll('.custom-multiselect .dropdown-content');
  dropdowns.forEach( dropdown =>{
    const checkboxes = dropdown.querySelectorAll('input[type="checkbox"]');
    if(btnSelect){
      btnSelect.addEventListener('click',  e => {
        e.preventDefault();
        checkboxes.forEach(cb => cb.checked = true);
        checkboxes.forEach(cb => cb.dispatchEvent(new Event('change')));
      })
    }
    if(btnDeselect){
      btnDeselect.addEventListener('click',  e => {
        e.preventDefault();
        checkboxes.forEach(cb => cb.checked = false);
        checkboxes.forEach(cb => cb.dispatchEvent(new Event('change')));
      })
    }
  })
    const groups = document.querySelectorAll('.custom-multiselect .group');
    groups.forEach(group => {
      const title = group.querySelector('.town'); // <strong> amarillo
      const subCheckboxes = group.querySelectorAll('input[type="checkbox"]');
      if (!title || subCheckboxes.length === 0) return;

      // Clic en el título => alterna todos los checkboxes del grupo
      title.addEventListener('click', () => {
        const someUnchecked = Array.from(subCheckboxes).some(cb => !cb.checked);
        subCheckboxes.forEach(cb => {
          cb.checked = someUnchecked;
          cb.dispatchEvent(new Event('change'));
        });
      });

      subCheckboxes.forEach(cb => {
        cb.addEventListener('change', () => {
          const total = subCheckboxes.length;
          const checkedCount = Array.from(subCheckboxes).filter(c => c.checked).length;
        });
      });
    })
});
