<?php
if (!defined('ABSPATH')) exit;

if (empty($property)) {
    echo '<div class="property-single-container"><p>Property not found.</p></div>';
    return;
}

$dynamic_css = "
:root {
  --page-width: {$options['pageWidth']};
  --btn-details-color: {$options['btnDetails']};
  --text-size: {$options['textSize']};
  --card-bg: {$options['cardBg']};
}";
wp_add_inline_style('zoddak-property-detail-style', $dynamic_css);

$primary_color = $options['btnDetails'] ?: '#e65638';
$type_color = $options['btnTypeColor'] ?: '#dddd0f';
$description = $property['description'] ?? '';
$lang = strtolower(substr(get_locale(), 0, 2));

$labels = [
    'features' => [
        'es' => 'Características',
        'en' => 'Features',
        'fr' => 'Caractéristiques',
        'de' => 'Merkmale',
        'da' => 'Funktioner',
        'no' => 'Funksjoner',
        'fi' => 'Ominaisuudet',
        'ru' => 'Особенности',
        'sv' => 'Funktioner',
    ],
    'description' => [
        'es' => 'Descripción',
        'en' => 'Description',
        'fr' => 'Description',
        'de' => 'Beschreibung',
        'da' => 'Beskrivelse',
        'no' => 'Beskrivelse',
        'fi' => 'Kuvaus',
        'ru' => 'Описание',
        'sv' => 'Beskrivning',
    ],
    'units_available' => [
        'es' => 'Unidades disponibles',
        'en' => 'Units available',
        'fr' => 'Unités disponibles',
        'de' => 'Verfügbare Einheiten',
        'da' => 'Ledige enheder',
        'no' => 'Tilgjengelige enheter',
        'fi' => 'Saatavilla olevat yksiköt',
        'ru' => 'Доступные объекты',
        'sv' => 'Tillgängliga enheter',
    ],
    'total' => [
        'es' => 'Total',
        'en' => 'Total',
        'fr' => 'Total',
        'de' => 'Gesamt',
        'da' => 'I alt',
        'no' => 'Totalt',
        'fi' => 'Yhteensä',
        'ru' => 'Всего',
        'sv' => 'Totalt',
    ],
    'bedrooms' => [
        'es' => 'Dormitorios',
        'en' => 'Bedrooms',
        'fr' => 'Chambres',
        'de' => 'Schlafzimmer',
        'da' => 'Soveværelser',
        'no' => 'Soverom',
        'fi' => 'Makuuhuoneet',
        'ru' => 'Спальни',
        'sv' => 'Sovrum',
    ],
    'bathrooms' => [
        'es' => 'Baños',
        'en' => 'Bathrooms',
        'fr' => 'Salles de bain',
        'de' => 'Badezimmer',
        'da' => 'Badeværelser',
        'no' => 'Bad',
        'fi' => 'Kylpyhuoneet',
        'ru' => 'Ванные комнаты',
        'sv' => 'Badrum',
    ],
    'built_area' => [
        'es' => 'Área construida',
        'en' => 'Built area',
        'fr' => 'Surface construite',
        'de' => 'Wohnfläche',
        'da' => 'Boligareal',
        'no' => 'Bruksareal',
        'fi' => 'Rakennettu pinta-ala',
        'ru' => 'Площадь здания',
        'sv' => 'Byggd yta',
    ],
    'plot_area' => [
        'es' => 'Área de parcela',
        'en' => 'Plot area',
        'fr' => 'Surface du terrain',
        'de' => 'Grundstücksfläche',
        'da' => 'Grundareal',
        'no' => 'Tomteareal',
        'fi' => 'Tontin pinta-ala',
        'ru' => 'Площадь участка',
        'sv' => 'Tomtyta',
    ],
    'price' => [
        'es' => 'Precio (€)',
        'en' => 'Price (€)',
        'fr' => 'Prix (€)',
        'de' => 'Preis (€)',
        'da' => 'Pris (€)',
        'no' => 'Pris (€)',
        'fi' => 'Hinta (€)',
        'ru' => 'Цена (€)',
        'sv' => 'Pris (€)',
    ],
    'location' => [
        'es' => 'Ubicación',
        'en' => 'Location',
        'fr' => 'Emplacement',
        'de' => 'Standort',
        'da' => 'Placering',
        'no' => 'Beliggenhet',
        'fi' => 'Sijainti',
        'ru' => 'Расположение',
        'sv' => 'Plats',
    ],
    'inquire' => [
        'es' => 'Solicitar información sobre esta propiedad',
        'en' => 'Inquire about this property',
        'fr' => 'Demandez des informations sur cette propriété',
        'de' => 'Anfrage zu dieser Immobilie',
        'da' => 'Forespørg om denne ejendom',
        'no' => 'Forespør om denne eiendommen',
        'fi' => 'Kysy tästä kohteesta',
        'ru' => 'Запросить информацию об этом объекте',
        'sv' => 'Fråga om denna fastighet',
    ],
    'back_to_properties' => [
        'es' => 'Volver a propiedades',
        'en' => 'Back to properties',
        'fr' => 'Retour aux propriétés',
        'de' => 'Zurück zu den Immobilien',
        'da' => 'Tilbage til ejendomme',
        'no' => 'Tilbake til eiendommer',
        'fi' => 'Takaisin kohteisiin',
        'ru' => 'Назад к объектам',
        'sv' => 'Tillbaka till fastigheter',
    ],
    'preposition' => [
        'es' => 'en',
        'en' => 'in',
        'fr' => 'à',
        'de' => 'in',
        'da' => 'i',
        'no' => 'i',
        'fi' => 'ssa', // normalmente se añade al final (específico del idioma)
        'ru' => 'в',
        'sv' => 'i',
    ],
    'prop_type' => [
        'Apartment' => [
        'es' => 'Apartamento',
        'en' => 'Apartment',
        'fr' => 'Appartement',
        'de' => 'Wohnung',
        'da' => 'Lejlighed',
        'no' => 'Leilighet',
        'fi' => 'Huoneisto',
        'ru' => 'Квартира',
        'sv' => 'Lägenhet',
    ],
    'Villa' => [
        'es' => 'Villa',
        'en' => 'Villa',
        'fr' => 'Villa',
        'de' => 'Villa',
        'da' => 'Villa',
        'no' => 'Villa',
        'fi' => 'Huvila',
        'ru' => 'Вилла',
        'sv' => 'Villa',
    ],
    'Townhouse' => [
        'es' => 'Casa adosada',
        'en' => 'Townhouse',
        'fr' => 'Maison de ville',
        'de' => 'Reihenhaus',
        'da' => 'Rækkehus',
        'no' => 'Rekkehus',
        'fi' => 'Rivitalo',
        'ru' => 'Таунхаус',
        'sv' => 'Radhus',
    ],
    ]
];
?>
<link rel="stylesheet"
      href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">


<div class="property-single-container" 
     style="--btn-details-color: <?= esc_attr($primary_color);?>;--primary-color: <?= esc_attr($primary_color) ?>; --property-type-bg-color: <?= esc_attr($type_color) ?>; --page-width: <?= esc_attr($options['pageWidth']) ?>;">
     
    <div class="language-switcher" style="display: none;">
        <button class="language-switcher-btn active" data-language="en">English</button>
        <button class="language-switcher-btn" data-language="es">Spanish</button>
        <button class="language-switcher-btn" data-language="nl">Dutch</button>
        <button class="language-switcher-btn" data-language="fr">French</button>
    </div>

    <div class="property-back-link">
        <a href="#" onclick="history.back(); return false;">← <span><?= $labels['back_to_properties'][$lang] ?? 'Back to Properties'; ?></span></a>    
    </div>

   <!-- Gallery -->
<div class="property-gallery-section">
  <div class="property-gallery">

    <?php if (!empty($property['images_lg'])): ?>
      <?php
        $images = $property['images_lg'];
        $total_images = count($images);
        $visible_thumbs = 5;
      ?>

      <!-- Swiper principal -->
      <div class="swiper main-swiper">
        <div class="swiper-wrapper">
          <?php foreach ($images as $img): ?>
            <div class="swiper-slide">
              <img src="<?= esc_url($img) ?>" alt="<?= esc_attr($property['name']) ?>">
            </div>
          <?php endforeach; ?>
        </div>

        <!-- Flechas -->
        <div class="swiper-button-prev"></div>
        <div class="swiper-button-next"></div>
      </div>

      <!-- Miniaturas -->
      <div class="thumbs-wrapper">
        <div class="swiper thumbs-swiper">
          <div class="swiper-wrapper">
            <?php foreach ($images as $index => $img): ?>
                <div class="swiper-slide">
                  <img src="<?= esc_url($img) ?>" alt="Thumbnail <?= $index + 1 ?>">
                </div>
            <?php endforeach; ?>
          </div>
        </div>
      </div>

    <?php endif; ?>
  </div>
</div>



<script>
  window.propertyImages = <?= json_encode($property['images_lg']); ?>;
</script>
    <!-- Property info -->
    <!-- Features -->
    <div class="property-single-header">
        <h1 class="property-title">
            <?= esc_html(buildPropName($property['prop_type'], $property['stage'], $property['town'], $lang, $labels)); ?>

        </h1>
        <div class="property-ref"><strong>#</strong><?=esc_html($property['reference']) ?></div>
        <div class="property-meta">
            <?php if (!empty($property['max_price'])): ?>
                <div class="property-price">
                    <?php if(!empty($property['min_price'] || !empty($property['max_price']))):?>
                        <?php if($property['min_price'] === $property['max_price']):?>
                            <span class="price-title">
                                <?= $property['price_title'];?>    
                            </span> 
                            <?= number_format($property['max_price'], 0, ',', '.') ?>€
                        <?php else:?>
                            <span class="price-title">
                                <?= $property['price_title'];?>    
                            </span> 
                            <?= number_format($property['min_price']);?>
                            <span class="price-title">
                            to
                            </span>  
                            <?= number_format($property['max_price']);?>€
                        <?php endif;?>
                    <?php endif;?>
                </div>
            <?php endif; ?>

            <?php if (!empty($property['prop_type'])): ?>
                <div class="property-type" 
                    >
                    <span><?= esc_html($property['prop_type']) ?></span>
                </div>
            <?php endif; ?>
            <?php if (!empty($property['stage'])): ?>
                <div class="property-stage" >
                    <span><?= esc_html($property['stage']) ?></span>
                </div>
            <?php endif; ?>

            <div class="property-location"><?= esc_html($property['place'] ??  '') ?></div>
        </div>
    </div>
    <div class="property-info-section">
        <div class="property-info-column">

        
            <div class="property-features-section">
                <h3><?= $labels['features'][$lang] ?? 'Features';?></h3>
            </div>
            <div class="property-info-container">

                <table class="property-features-table">
                    <tbody>
                        <?php if (!empty($property['max_beds']) || $property['min_beds']): ?>
                            <?php if($property['min_beds'] === $property['max_beds']):?>
                                <tr>
                                    <th><i class="fas fa-bed"></i></th>
                                    <td><?= number_format($property['max_beds']);?> <?= $labels['bedrooms'][$lang];?></td>

                                </tr>
                            <?php else:?>
                            <tr>
                                <th><i class="fas fa-bed"></i></th>
                                <td><?= number_format($property['min_beds'], 0, ',', '.') ?> - <?= number_format($property['max_beds']);?> <?= $labels['bedrooms'][$lang];?></td>
                            </tr>
                            <?php endif;?>
                        <?php endif; ?>
                            
                        <?php if (!empty($property['max_baths']) || $property['min_baths']): ?>
                            <?php if($property['min_baths'] === $property['max_baths']):?>
                                <tr>
                                <th><i class="fas fa-bath"></i></th>
                                    <td><?= number_format($property['max_baths']);?> <?= $labels['bathrooms'][$lang];?></td>

                                </tr>
                            <?php else:?>
                            <tr>
                                <th><i class="fas fa-bath"></i></th>
                                <td><?= number_format($property['min_baths'], 0, ',', '.') ?> - <?= number_format($property['max_baths']);?> <?= $labels['bathrooms'][$lang];?></td>
                            </tr>
                            <?php endif;?>
                        <?php endif; ?>

                        <?php if (!empty($property['max_built_area']) || $property['min_built_area']): ?>
                            <?php if($property['min_built_area'] === $property['max_built_area']):?>
                                <tr>
                                    <th><span class="dashicons dashicons-admin-home"></th>
                                    <td><?= number_format($property['max_built_area']);?> m2 <?= $labels['built_area'][$lang];?></td>

                                </tr>
                            <?php else:?>
                            <tr>
                                <th><span class="dashicons dashicons-admin-home"></span></th>
                                <td><?= number_format($property['min_built_area'], 0, ',', '.') ?> - <?= number_format($property['max_built_area']);?> m2 <?= $labels['built_area'][$lang];?></td>
                            </tr>
                            <?php endif;?>
                        <?php endif; ?>

                        <?php if (!empty($property['max_plot_area']) || $property['min_plot_area']): ?>
                            <?php if($property['min_plot_area'] === $property['max_plot_area']):?>
                                <tr>
                                    <th><span class="dashicons dashicons-layout"></span></th>
                                    <td><?= number_format($property['max_plot_area']);?> m2 <?= $labels['plot_area'][$lang];?></td>

                                </tr>
                            <?php else:?>
                            <tr>
                                <th><span class="dashicons dashicons-layout"></span></th>
                                <td><?= number_format($property['min_plot_area'], 0, ',', '.') ?> - <?= number_format($property['max_built_area']);?> m2 <?= $labels['plot_area'][$lang];?></td>
                            </tr>
                            <?php endif;?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>

            <?php if (!empty($description)): ?>
                <div class="property-description">
                    <h3><?= $labels['description'][$lang] ?? 'Description'; ?></h3>
                    <div class="property-description-content">
                        <?= wp_kses_post($description) ?>
                    </div>
                </div>
            <?php endif; ?>
            <?php 
                $remaining = $property['units_total'] - $property['units_sold']
            ;?> 
            <?php if(!empty($unitsData)):?>
                <div class="property-units">
                    <h3><?= $labels['units_available'][$lang] ?? 'Units available'; ?></h3>
                    <div class="units-title">
                        <span>Total: <?=$remaining;?></span>
                    </div>
                    <div class="box-content-units">
                        <?php foreach($unitsData as $key => $unit):?>
                            <div class="box-outter">
                                <div class="box-total-units">
                                    <i class="fas fa-bed"></i>
                                    <span><?= T_('Bedrooms') ?> <?= $key; ?></span>
                                    <span class="total-available"><?= $unit['count']; ?> <?= T_('Units') ?></span>
                                </div>
                                <i class="fas fa-chevron-down arrow"></i>
                                </div>

                                <div class="box-collapse">
                                    <table class="units-table">
                                        <thead>
                                        <tr>
                                            <th><?= T_('Unit') ?></th>
                                            <th><?= T_('Baths') ?></th>
                                            <th><?= T_('Built Area') ?></th>
                                            <th><?= T_('Plot Area') ?></th>
                                            <th><?= T_('Price (€)') ?></th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <?php foreach ($unit['units'] as $subunit): ?>
                                            <tr class="table-row">
                                                <td><?= $subunit['name']; ?></td>
                                                <td><?= $subunit['baths']; ?></td>
                                                <td><?= $subunit['builtArea'];?>m2</td>
                                                <td><?= $subunit['plotArea'];?>m2</td>
                                                <td><?= number_format($subunit['price']); ?></td>
                                            </tr>
                                        <?php endforeach; ?>
                                        </tbody>
                                    </table>
                                    </div>

                        <?php endforeach;?>
                    </div>
                </div>
            <?php endif;?>
            <!-- Map -->
            <?php if (!empty($property['latitude']) && !empty($property['longitude'])): ?>
                <div class="property-map-section">
                    <h3><?= $labels['location'][$lang] ?? 'Location'; ?></h3>
                    <div id="property-map" 
                         style="height: 400px; width: 100%; margin-bottom: 20px;"
                         data-lat="<?= esc_attr($property['latitude']) ?>"
                         data-lng="<?= esc_attr($property['longitude']) ?>"
                         data-color="<?= esc_attr($primary_color) ?>">
                    </div>
                </div>
            <?php endif; ?>
        </div>

        <!-- Contact -->
        <div class="property-contact-column">
            <div class="property-contact-form">
                <h2><?= $labels['inquire'][$lang] ?? 'Inquire about this property'; ?></h2>
                <?php
                    $form_shortcode = !empty($options['contactForm']) ? $options['contactForm'] : '';
                    if ($form_shortcode) {
                        echo do_shortcode($form_shortcode);
                    } else {
                        // Si no hay formulario, mostramos uno por defecto o un aviso
                        echo do_shortcode('[contact-form-7 id="2456" title="Property Contact"]');
                        echo '<div class="zoddak-contact-warning" style="margin-top:10px; background:#fff8e5; border:1px solid #f3c65c; border-radius:8px; padding:12px; color:#8a6d3b; font-size:14px;">
                                ⚠️ No custom contact form configured. Default form loaded.
                            </div>';
                    }
                    ?>
            </div>
        </div>
    </div>
</div>
