<div class="wrap">
  <h1><?=T_('Customize Filters')  ?></h1>
  <p><?= T_('Here you can adjust the filters visible in the search engine.') ?></p>
      <?php settings_errors(); ?>
  <div class="customization-container">

      <div class="customization-form">
            <form method="post" action="options.php">
                <?php
                settings_fields('zoddak_filter_display_group');
                do_settings_sections('zoddak_filter_display_page');
                submit_button(T_('Save changes'));
                ?>
            </form>
        </div>

      <div class="preview-container">
          <h3><?= T_('Preview') ?></h3>
          <!-- Vista previa del menú de búsqueda -->
          <div id="filterCard" style="
                padding: 20px;
                border-radius: 8px;
                border: 1px solid #ddd;
                background-color: <?php echo get_option('zoddak-bg-color-search-menu', '#f5f5f5'); ?>;
            ">
              <h4 style="margin-top: 0;"><?= T_('Find properties') ?></h4>
              <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 15px; margin-bottom: 15px;">
                  <div>
                      <label><?= T_('Location') ?></label>
                      <input type="text" style="width: 100%; padding: 8px; border: 1px solid #ddd; border-radius: 4px;" placeholder="Ingrese ubicación">
                  </div>
                  <div>
                      <label><?= T_('Property type') ?></label>
                      <select style="width: 100%; padding: 8px; border: 1px solid #ddd; border-radius: 4px;">
                          <option><?= T_('Any') ?></option>
                          <option><?= T_('Apartments') ?></option>
                          <option><?= T_('Townhouses') ?></option>
                          <option><?= T_('Villas') ?></option>
                      </select>
                  </div>
                  <div>
                      <label><?= T_('Minimum Price') ?></label>
                      <input type="number" style="width: 100%; padding: 8px; border: 1px solid #ddd; border-radius: 4px;" placeholder="0">
                  </div>
                  <div>
                      <label><?= T_('Maximum Price') ?></label>
                      <input type="number" style="width: 100%; padding: 8px; border: 1px solid #ddd; border-radius: 4px;" placeholder="1000000">
                  </div>
              </div>
              <div style="display: flex; gap: 10px; justify-content: center;">
                  <button  id="findBtn" style="
                      padding: 8px 20px;
                      background-color: #070100;
                      color: white;
                      border: none;
                      border-radius: 4px;
                      cursor: pointer;
                  "><?= T_('Search') ?></button>
                  <button style="
                      padding: 8px 20px;
                      background-color: #070100;
                      color: white;
                      border: none;
                      border-radius: 4px;
                      cursor: pointer;
                  "><?= T_('Find') ?></button>
                  <button id="resetBtn" style="
                      padding: 8px 20px;
                      background-color: <?php echo get_option('zoddak-reset-btn-color', '#ffffff'); ?>;
                      color: #333;
                      border: none;
                      border-radius: 4px;
                      cursor: pointer;
                  "><?= T_('Reset') ?></button>
              </div>
          </div>
      </div>
  </div>
</div>
