<?php
/*
Plugin Name: Zoddak New Developments Connector v2
 * Plugin URI: https://www.zoddak.com/
 * Description: 2º version for Zoddak's new developments, displays them professionally and responsively on your website.
 * Version: 1.0.2
 * Author: Zoddak
 * Author URI: https://www.zoddak.com/
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: new-devs.v2
 * Domain Path: /languages
*/

// Seguridad: evita que el archivo se ejecute directamente
if (!defined('ABSPATH')) {
    exit;
}
define('ZODDAK_PLUGIN_URL', plugin_dir_url(__FILE__));
require_once plugin_dir_path(__FILE__) . 'helpers/functions-helper.php';
require_once plugin_dir_path(__FILE__) . 'includes/admin-menu.php';
require_once plugin_dir_path(__FILE__) . 'controllers/AdminController.php';
require_once plugin_dir_path(__FILE__) . 'controllers/ApiController.php';
require_once plugin_dir_path(__FILE__) . 'controllers/PropertiesController.php';
add_action('init', function() {
    load_plugin_textdomain(
        'new-devs.v2', // Debe coincidir con el Text Domain del header
        false,
        dirname(plugin_basename(__FILE__)) . '/languages/'
    );
});



function mpp_mensaje_bienvenida() {
    echo "
        <div class='notice notice-success is-dismissible'>
            <p>¡New Developments está activo y funcionando!</p>
        </div>";
}
add_action('admin_init', ['AdminController', 'registerSettings']);
add_action('admin_init', ['AdminController', 'registerPropertyDisplaySettings']);
add_action('admin_init', ['AdminController', 'registerFilterDisplaySettings']);
add_action('admin_init', ['AdminController', 'customizePropertyDetails']);

add_action('admin_init', ['AdminController', 'newDevsSettings']);
add_action('init', ['ApiController', 'registerRoutes']);
add_action('template_redirect', function() {

    // 1. ¿Propiedad individual?
    if ($ref = get_query_var('zoddak_property_ref')) {
        PropertiesController::renderPropertyDetail($ref);
        exit;
    }

    // 2. ¿Ruta custom?
    if ($route = get_query_var('zoddak_custom_route')) {
        ApiController::handleCustomRoute();
        exit;
    }

    // 3. Página normal
    // PropertiesController::renderPropertiesPage();
    // exit;
});

// add_action('template_redirect', ['ApiController', 'handleCustomRoute']);

register_activation_hook(__FILE__, function() {
    add_option('zoddak_property_layout', 'horizontal');
    add_option('zoddak_card_size', 'small');
    add_option('zoddak_page_width', '960px');
    add_option('zoddak_card_bg_color', '#ffffff');
    add_option('zoddak_border_rounded', '7px');
    add_option('zoddak_color_button_details', '#000000');
    add_option('zoddak_type_property_btn_color', '#dddd0f');
    add_option('zoddak_type_property_txt_color', '#ffffff');
    add_option('zoddak_color_horizontal_line', '#c61c1c');
    add_option('zoddak_current_page_color', '#110400');
});
register_activation_hook(__FILE__, function() {
    if (function_exists('do_action')) {
        do_action('kinsta_cache_purge');
    }

    // Registrar rutas nuevas
    if (method_exists('ApiController', 'registerRoutes')) {
        ApiController::registerRoutes();
    }

    flush_rewrite_rules();
});
function zoddak_admin_assets($hook_suffix) {

    wp_enqueue_style('wp-color-picker');
    wp_enqueue_script('wp-color-picker');
    wp_add_inline_script(
        'wp-color-picker',
        'jQuery(document).ready(function($){$(".my-color-field").wpColorPicker();});'
    );

    wp_enqueue_script(
        'zoddak-admin-js',
        plugin_dir_url(__FILE__) . 'assets/custom-properties-display.js',
        ['jquery', 'wp-color-picker'],
        '1.0.0',
        true
    );

    wp_enqueue_script(
        'zoddak-custom-filter-card', 
        plugin_dir_url(__FILE__) . 'assets/custom-filter-card.js',
        ['jquery', 'wp-color-picker'], 
        '1.0.0', 
        true
    );


    wp_localize_script('zoddak-admin-js', 'zoddakVars', [
        'previewSelector' => '#property-preview'
    ]);
    $options = [
        'horizontalLineColor' => get_option('zoddak_color_horizontal_line', '#c61c1c'),
        'typeRefColor' => get_option('zoddak_type_property_btn_color'),
        'currentPageColor' => get_option('zoddak_current_page_color'),
        'cardBgColor' => get_option('zoddak_card_bg_color'),
        'cardBorder' => get_option('zoddak_border_rounded')
    ];
    wp_enqueue_style(
        'zoddak-admin-style-base',
        plugin_dir_url(__FILE__) . 'assets/style.css',
        [],
        filemtime(plugin_dir_path(__FILE__) . 'assets/style.css')
    );
    $root = "
        :root{
            --line-hor: {$options['horizontalLineColor']};
            --ref-type-color: {$options['typeRefColor']};
            --current-page-color: {$options['currentPageColor']};
            --card-bg-color: {$options['cardBgColor']};
            --card-border: {$options['cardBorder']};
        }
    ";
    wp_add_inline_style('zoddak-admin-style-base', $root);
    
    wp_enqueue_style(
        'zoddak-admin-style-detail',
        plugin_dir_url(__FILE__) . 'assets/custom-details-page.css',
        ['dashicons'], 
        filemtime(plugin_dir_path(__FILE__) . 'assets/custom-details-page.css')
    );
    $options = [
        'bgFeatureColor' => get_option('zoddak-icons-color', '#110400'),
        'bgTxtFeatureColor' => get_option('zoddak-icons-txt-color')
    ];
    $dynamicCss = "
        :root {
            --bg-features-color : {$options['bgFeatureColor']};
            --color-text-features : {$options['bgTxtFeatureColor']};
        }      
    ";
    wp_add_inline_style('zoddak-admin-style-detail', $dynamicCss);
    wp_enqueue_style(
    'font-awesome',
    'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css',
    [],
    '6.5.0'
    );
    wp_enqueue_script(
        'zoddak-custom-details-interactions',
        plugin_dir_url(__FILE__) . 'assets/custom-details-page.js',
        ['jquery'],
        filemtime(plugin_dir_path(__FILE__) . 'assets/custom-details-page.js'),
        true
    );
    wp_enqueue_script(
        'zoddak-newdevs-admin',
        plugin_dir_url(__FILE__) . 'assets/newdevs_admin_settings.js',
        ['jquery'],
        filemtime(plugin_dir_path(__FILE__) . 'assets/newdevs_admin_settings.js'),
        true
    );
    // // === Select2 ===
    wp_enqueue_style(
        'select2-css',
        'https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css'
    );
    wp_enqueue_script(
        'select2-js',
        'https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js',
        ['jquery'],
        null,
        true
    );

    // Tus estilos personalizados
    wp_enqueue_style(
        'zoddak-admin-settings',
        plugin_dir_url(__FILE__) . 'assets/newdevs-admin-settings.css',
        [],
        filemtime(plugin_dir_path(__FILE__) . 'assets/newdevs-admin-settings.css')
    );

}
add_action('admin_enqueue_scripts', 'zoddak_admin_assets');
function zoddak_front_styles() {
    if (!get_query_var('zoddak_custom_route') && !get_query_var('zoddak_property_ref')) {
        return;
    }
    $options = [
        'bgFeatureColor' => get_option('zoddak-icons-color', '#110400'),
        'bgTxtFeatureColor' => get_option('zoddak-icons-txt-color', '#000000'),
        'bgStageColor' => get_option('zoddak-btn-stage-color'),
        'bgPriceColor' => get_option('zoddak-btn-price-color'),
    ];

    $dynamicCss = "
    :root {
        --bg-features-color: {$options['bgFeatureColor']};
        --color-text-features: {$options['bgTxtFeatureColor']};
        --bg-price-color: {$options['bgPriceColor']};
        --bg-stage-color: {$options['bgStageColor']};
    }";

    wp_enqueue_style(
        'zoddak-property-detail-style',
        plugin_dir_url(__FILE__) . 'assets/property-details.css',
        [],
        filemtime(plugin_dir_path(__FILE__) . 'assets/property-details.css')   // ✔ CORRECTO
    );

    wp_add_inline_style('zoddak-property-detail-style', $dynamicCss);
    $options = [
            'apiUrl'        => get_option('zoddak_api_url'),
            'token'         => get_option('zoddak_api_token'),
            'perPage'       => get_option('zoddak_items_per_page', 10),
            'layout'        => get_option('zoddak_property_layout', 'horizontal'),
            'cardSize'      => get_option('zoddak_card_size', 'small'),
            'cardBg'        => get_option('zoddak_card_bg_color', '#ffffff'),
            'textSize'      => get_option('zoddak_text_size', '14px'),
            'pageWidth'     => get_option('zoddak_page_width', '1200px'),
            'btnDetails'    => get_option('zoddak_color_button_details', '#020202'),
            'btnTypeColor'  => get_option('zoddak_type_property_btn_color', '#dddd0f'),
            'btnTypeTxt'    => get_option('zoddak_type_property_txt_color', '#ffffff'),
            'hoverColor'    => get_option('zoddak_hover_color', '#110400'),
            'currentColor'  => get_option('zoddak_current_page_color', '#110400'),
            'filterBg'      => get_option('zoddak-bg-color-search-menu', '#f5f5f5'),
            'filterBtn'     => get_option('zoddak-btn-color-search-menu', '#070100'),
            'filterReset'   => get_option('zoddak-reset-btn-color', '#ffffff'),
            'borderRadius'  => get_option('zoddak_border_rounded', true),
            'horizontalLine' => get_option('zoddak_color_horizontal_line', '#c61c1c'),
            'currentPageColor' => get_option('zoddak_current_page_color', 'black'),
            'pageHoverColor' => get_option('zoddak_hover_color', 'green')
        ];
    $dynamic_css = "
        :root{
        --page-width: {$options['pageWidth']};
        --text-size: {$options['textSize']};
        --card-size: {$options['cardSize']};
        --card-bg: {$options['cardBg']};
        --btn-details: {$options['btnDetails']};
        --type-btn-bg: {$options['btnTypeColor']};
        --type-btn-color: {$options['btnTypeTxt']};
        --hover-color: {$options['hoverColor']};
        --current-color: {$options['currentColor']};
        --filter-bg: {$options['filterBg']};
        --filter-btn: {$options['filterBtn']};
        --filter-reset: {$options['filterReset']};
        --text-size: {$options['textSize']};
        --border-radius: {$options['borderRadius']};
        --line-color: {$options['horizontalLine']};
        --current-page-color: {$options['currentPageColor']};
        }";
    wp_enqueue_style(
        'zoddak-page-properties-style',
        plugin_dir_url(__FILE__) . 'assets/page-properties.css',
        [],
        filemtime(plugin_dir_path(__FILE__) . 'assets/page-properties.css')
    );
    wp_add_inline_style('zoddak-page-properties-style', $dynamic_css);

    // === JS de la página de propiedades ===
    wp_enqueue_script(
        'zoddak-property-page',
        plugin_dir_url(__FILE__) . 'assets/page-properties.js',
        [],
        filemtime(plugin_dir_path(__FILE__) . 'assets/page-properties.js'),    // ✔ CORRECTO
        true
    );
}

add_action('wp_enqueue_scripts', 'zoddak_front_styles');


// Crea una regla para detectar URLs como /propiedades/REF12345
function zoddak_add_property_detail_rewrite() {
    add_rewrite_rule(
        '^propiedades/([^/]+)/?',
        'new-devs.v2.php?zoddak_property_ref=$matches[1]',
        'top'
    );
}
add_action('init', 'zoddak_add_property_detail_rewrite');

// Declara el query var para que WordPress lo reconozca
function zoddak_add_property_query_var($vars) {
    $vars[] = 'zoddak_property_ref';
    return $vars;
}
add_filter('query_vars', 'zoddak_add_property_query_var');
add_action('template_redirect', function() {
    $ref = get_query_var('zoddak_property_ref');
    if ($ref) {
        PropertiesController::renderPropertyDetail($ref);
        exit;
    }
});


function zoddak_enqueue_leaflet() {
    wp_enqueue_style('leaflet-css', 'https://unpkg.com/leaflet@1.9.4/dist/leaflet.css');
    wp_enqueue_script('leaflet-js', 'https://unpkg.com/leaflet@1.9.4/dist/leaflet.js', [], null, true);
}
add_action('wp_enqueue_scripts', 'zoddak_enqueue_leaflet');
function enqueue_prop_details_script() {
    if (get_query_var('zoddak_property_ref')) {

        wp_enqueue_style('bootstrap-css', 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css');
        wp_enqueue_script('bootstrap-js', 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js', array('jquery'), '5.3.3', true);

        wp_enqueue_style('swiper-css', 'https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css');
        wp_enqueue_script('swiper-js', 'https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js', array(), '11.0.0', true);

        wp_enqueue_script(
            'property-details-script',
            plugin_dir_url(__FILE__) . 'assets/property-details-script.js',
            array('swiper-js', 'bootstrap-js'),
            '1.0.0',
            true
        );
        if (get_query_var('zoddak_property_ref')) { 
            $options = [
                'border' => get_option('zoddak_border_rounded'),
            ];
            $root = "
            :root{
                --border-value : {$options['border']};
            }
            ";
            wp_enqueue_style(
                'zoddak-property-details',
                plugins_url('assets/property-details.css', __FILE__),
                array(),
            );
            wp_add_inline_style('zoddak-property-details', $root);

        }
    }
}
add_action('wp_enqueue_scripts', 'enqueue_prop_details_script');
if (!defined('ABSPATH')) {
    exit;
}
function enqueue_select2_assets() {
    wp_enqueue_style('select2', 'https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css');
    wp_enqueue_script('select2', 'https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js', ['jquery'], null, true);
    wp_add_inline_script('select2', "jQuery(document).ready(function($){ $('#area').select2({ placeholder: 'Select areas', width: '100%', allowClear: true }); });");
}

add_action('wp_enqueue_scripts', 'enqueue_select2_assets');
add_action('wp_head', function() {
    echo '<meta name="viewport" content="width=device-width, initial-scale=1">';
}, 1);
function zoddak_enqueue_fontawesome_global() {

    if ( ! wp_style_is( 'font-awesome-5', 'enqueued' ) ) {
        wp_enqueue_style(
            'font-awesome-5',
            'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css',
            array(),
            '5.15.4'
        );
    }
}
add_action('wp_enqueue_scripts', 'zoddak_enqueue_fontawesome_global', 100);

add_action('admin_enqueue_scripts', 'zoddak_enqueue_fontawesome_global', 5);
function zoddak_newdevs_load_textdomain() {
    switch_to_locale(get_locale());
    load_plugin_textdomain(
        'new-devs.v2',
        false,
        dirname(plugin_basename(__FILE__)) . '/languages/'
    );
}
add_action('plugins_loaded', 'zoddak_newdevs_load_textdomain');
add_filter('wpcf7_collect_mail_tags', function($tags) {
    if (!in_array('_zoddak_emails', $tags, true)) {
        $tags[] = '_zoddak_emails';
    }
    return $tags;
});

add_filter('wpcf7_special_mail_tags', function($output, $name) {
    if($name === '_zoddak_emails') {
        $selectedEmails = get_option('zoddak_newdevs_contact_users', []);
        return !empty($selectedEmails)
            ? implode(', ', $selectedEmails)
            : get_option('admin_email');
    }
    return $output;
}, 10, 2);

add_filter('wpcf7_mail_failed', function($mail) {
    error_log('CF7 Mail Failed: ' . print_r($mail, true));
}, 10, 2);

add_action('update_option_zoddak_custom_route', function($old, $new) {
    if ($old !== $new) {
        ApiController::registerRoutes();
        flush_rewrite_rules();
    }
}, 10, 2);
register_deactivation_hook(__FILE__, function() {
    if (function_exists('do_action')) {
        do_action('kinsta_cache_purge');
    }

    delete_option('rewrite_rules');
    flush_rewrite_rules();
});