<?php 
if(!defined('ABSPATH')){
    exit;
}

class ApiController{
    public static function registerRoutes() {
        $route = trim(get_option('zoddak_custom_route', 'propiedades'), '/');

        add_rewrite_rule(
            "^{$route}/?$",
            "index.php?zoddak_custom_route=1",
            "top"
        );
        add_rewrite_rule(
            '^' . $route . '/([^/]+)/?$',
            'index.php?zoddak_property_ref=$matches[1]',
            'top'
        );
        add_rewrite_tag('%zoddak_custom_route%', '([0-9]+)');
        add_filter('query_vars', function($vars) {
            $vars[] = 'zoddak_custom_route';
            return $vars;
        });
    }


    public static function handleCustomRoute() {
        PropertiesController::renderPropertiesPage();
        exit;
    }

    public static function validateApiToken($token) {
        if(empty($token)){
            return $token;
        }
        $apiUrl = esc_attr(get_option('zoddak_api_url', 'https://api.zoddak.com/v1/developments'));
        $response = wp_remote_get($apiUrl, [
            'headers' => [
                'Api-Token' => $token,
                'Accept' => 'application/json'
            ],
            'timeout' => 10
        ]);
        
        if(is_wp_error($response)){
            add_settings_error(
                'zoddak_api_token',
                'api_connection_failed',
                'No se pudo conectar a la API. Por favor, verifica la URL y el token.',
            );
            error_log('🔴 Error WP_Error en validateApiToken: ' . $response->get_error_message());
            add_settings_error('zoddak_api_token', 'api_connection_failed', 'Error al conectar con la API: ' . esc_html($response->get_error_message()));
            return get_option('zoddak_api_token');
        }
        $body = json_decode(wp_remote_retrieve_body($response), true);
        $status_code = $body['status'];
        if($status_code === 401 || $status_code === 403){
            add_settings_error(
                'zoddak_api_token',
                'api_invalid_token',
                $body['content'],
            );
            return get_option('zoddak_api_token');
        }
        if($status_code === 200){
            add_settings_error(
                'zoddak_api_token',
                'api_valid_token',
                'Token verificado con exito.',
                'updated'
            );
            return $token;
        }
        add_settings_error(
            'zoddak_api_token',
            'api_unknown_error',
            'No se pudo verificar el token. Código de estado:' . $status_code
        );
        return get_option('zoddak_api_token');
    }
    public static function get_areas()
    {
        $cache_key = 'zoddak_areas';
        $cached = get_transient($cache_key);

        if ($cached !== false) {
            return $cached;
        }

        $apiUrl = 'https://api.zoddak.com/v1/locations';
        $token = esc_attr(get_option('zoddak_api_token', ''));

        if (empty($token)) {
            return [];
        }

        $response = wp_remote_get($apiUrl, [
            'headers' => [
                'Api-Token' => $token,
                'Accept' => 'application/json'
            ],
            'timeout' => 10
        ]);

        $body = json_decode(wp_remote_retrieve_body($response), true);
        $locations = $body['locations'] ?? [];

        // Caché 6 horas
        set_transient($cache_key, $locations, 6 * HOUR_IN_SECONDS);

        return $locations;
    }


    public static function get_property_stage()
    {
        $cache_key = 'zoddak_property_stages';
        $cached = get_transient($cache_key);

        if ($cached !== false) {
            return $cached;
        }

        $apiUrl = 'https://api.zoddak.com/v1/stages';
        $token = esc_attr(get_option('zoddak_api_token', ''));

        if (empty($token)) {
            return [];
        }

        $response = wp_remote_get($apiUrl, [
            'headers' => [
                'Api-Token' => $token,
                'Accept' => 'application/json'
            ],
            'timeout' => 10
        ]);

        $body = json_decode(wp_remote_retrieve_body($response), true);
        $stages = $body['stages'] ?? [];

        // Caché 6 horas
        set_transient($cache_key, $stages, 6 * HOUR_IN_SECONDS);

        return $stages;
    }

}