<?php
if (!defined('ABSPATH')) exit;

class AdminController {

    public static function newDevsConfig() {
        include plugin_dir_path(__DIR__) . 'views/admin/page-new-devs.php';
    }

    public static function customizeProperties() {
        include plugin_dir_path(__DIR__) . 'views/admin/page-customize-properties-display.php';
    }

    public static function customizeFilters() {
        include plugin_dir_path(__DIR__) . 'views/admin/page-customize-filters.php';
    }
    public static function customizeDetails(){
        include plugin_dir_path(__DIR__) . 'views/admin/page-customize-property-details.php';
    }
    public static function newDevsSettingsView(){
        include plugin_dir_path(__DIR__) . 'views/admin/page-newdevs-admin-settings.php';
    }

    public static function registerSettings() {
        register_setting('zoddak_newdevs_group', 'zoddak_custom_route');
        register_setting('zoddak_newdevs_group', 'zoddak_api_url');
        register_setting('zoddak_newdevs_group', 'zoddak_api_token',[
            'sanitize_callback' => ['ApiController', 'validateApiToken']
        ]);
        register_setting('zoddak_newdevs_group', 'zoddak_items_per_page');
        register_setting('zoddak_newdevs_group', 'zoddak_restrict_admins');
        register_setting('zoddak_newdevs_group', 'zoddak_contact_shortcode');
        register_setting('zoddak_newdevs_group', 'zoddak_show_language_selector');

        add_settings_section(
            'zoddak_newdevs_section',
            T_('Properties Display Settings'),
            function() {
                echo '<p>'. T_('Configure your custom path and API key to display properties from the external API.') . '</p>';
            },
            'zoddak_newdevs_page'
        );

        add_settings_field(
            'zoddak_custom_route',
            T_('Custom Route'),
            function() {
                $route = ltrim(esc_attr(get_option('zoddak_custom_route', 'propiedades')), '/');
                echo '<input type="text" name="zoddak_custom_route" value="' . $route . '" class="regular-text">';
                echo '<p class="description">'. T_('Enter the custom path to display properties (for example,') . '<code>/properties</code>).<br>' . T_('Note: The path must begin with a slash.') . '<br>' . T_('Its properties will be accessible at:') . ' <code>' . home_url($route) . '</code></p>';
            },
            'zoddak_newdevs_page',
            'zoddak_newdevs_section'
        );

        add_settings_field(
            'zoddak_api_url',
            T_('API URL'),
            function() {
                $url = esc_attr(get_option('zoddak_api_url', 'https://api.zoddak.com/v1/developments'));
                echo '<input type="text" name="zoddak_api_url" value="' . $url . '" class="regular-text">';
                echo '<p class="description">' . T_('This is the base URL of the API endpoint: ') . ' <code>https://api.zoddak.com/v1/developments</code>.</p>';
            }, 
            'zoddak_newdevs_page',
            'zoddak_newdevs_section'
        );

        add_settings_field(
            'zoddak_api_token',
            T_('API Token'),
            function() {
                $token = esc_attr(get_option('zoddak_api_token', ''));
                echo '<input type="password" id="zoddak_api_token" name="zoddak_api_token" value="' . $token . '" class="regular-text">';
                echo '<button type="button" class="button" onclick="toggleApiToken()">👁️</button>';
                echo '<p class="description">' . T_('Enter your API key to access property data. Click the eye icon to show/hide.'). '</p>';
                echo '<script>
                    function toggleApiToken() {
                        const input = document.getElementById("zoddak_api_token");
                        input.type = (input.type === "password") ? "text" : "password";
                    }
                </script>';
            },
            'zoddak_newdevs_page',
            'zoddak_newdevs_section'
        );

        add_settings_field(
            'zoddak_restrict_admins',
            T_('Restrict to Administrators'),
            function() {
                $checked = checked(1, get_option('zoddak_restrict_admins', 0), false);
                echo '<label><input type="checkbox" name="zoddak_restrict_admins" value="1" ' . $checked . '>'. T_(' Only administrators can access property paths.') . '</label>';
                echo '<p class="description">' . T_('If enabled, only administrators will be able to access the custom path and property details.') . '</p>';
            },
            'zoddak_newdevs_page',
            'zoddak_newdevs_section'
        );

        add_settings_field(
            'zoddak_contact_shortcode',
            T_('Contact Form Shortcode'),
            function() {
                $shortcode = esc_attr(get_option('zoddak_contact_shortcode', '[contact-form-7 id="123" title="Contacto"]'));
                echo '<input type="text" name="zoddak_contact_shortcode" value="' . $shortcode . '" class="regular-text">';
                echo '<p class="description">' . T_('Enter the Contact Form 7 shortcode, for example:') . ' <code>[contact-form-7 id="123" title="Contacto"]</code>.</p>';
            }, 
            'zoddak_newdevs_page',
            'zoddak_newdevs_section'
        );
    }

   public static function registerPropertyDisplaySettings() 
   {
    // === REGISTRO DE TODOS LOS CAMPOS ===
    register_setting('zoddak_property_display_group', 'zoddak_property_layout');
    register_setting('zoddak_property_display_group', 'zoddak_card_size');
    register_setting('zoddak_property_display_group', 'zoddak_page_width');
    register_setting('zoddak_property_display_group', 'zoddak_card_bg_color');
    register_setting('zoddak_property_display_group', 'zoddak_border_rounded');
    register_setting('zoddak_property_display_group', 'zoddak_color_button_details');
    register_setting('zoddak_property_display_group', 'zoddak_type_property_btn_color');
    register_setting('zoddak_property_display_group', 'zoddak_type_property_txt_color');
    register_setting('zoddak_property_display_group', 'zoddak_color_horizontal_line');
    // register_setting('zoddak_property_display_group', 'zoddak_hover_color');
    register_setting('zoddak_property_display_group', 'zoddak_current_page_color');
    // register_setting('zoddak_property_display_group', 'zoddak_text_size');
    // === SECCIÓN: Página general ===
    add_settings_section(
        'zoddak_custom_page',
        'Personalizacion del layout',
        null,
        'zoddak_property_display_page'
    );

    add_settings_field(
        'zoddak_page_width',
        T_('Page width'),
        function() {
            $currentWidth = esc_attr(get_option('zoddak_page_width', '960px'));
            echo '<select name="zoddak_page_width">
                    <option value="960px" ' . selected($currentWidth, '960px', false) . '>'. T_('Stretch') .' (960px)</option>
                    <option value="1200px" ' . selected($currentWidth, '1200px', false) . '>'. T_('Medium') . ' (1200px)</option>
                    <option value="1400px" ' . selected($currentWidth, '1400px', false) . '> ' . T_('Wide') .'(1400px)</option>
                    <option value="100%" ' . selected($currentWidth, '100%', false) . '>' . T_('Total width') .' (100%)</option>
                </select>
                <p class="description">' . T_('Select the overall page size.').'</p>';
        },
        'zoddak_property_display_page',
        'zoddak_custom_page'
    );
    add_settings_field(
        'zoddak_property_layout',
        T_('Property Card Design'),
        function() {
            $layout = esc_attr(get_option('zoddak_property_layout', 'horizontal'));
            echo '<select name="zoddak_property_layout">
                    <option value="horizontal" ' . selected($layout, 'horizontal', false) . '>'. T_('Horizontal (Image on the left)') .'</option>
                    <option value="vertical" ' . selected($layout, 'vertical', false) . '>' . T_('Vertical (Image above)') . '</option>
                </select>
                <p class="description">'. T_('Select the design style for the property cards.').'</p>';
        },
        'zoddak_property_display_page',
        'zoddak_custom_page'
    );
    add_settings_field(
        'zoddak_card_size',
        T_('Card size'),
        function() {
            $size = esc_attr(get_option('zoddak_card_size', 'small'));
            echo '<select name="zoddak_card_size">
                    <option value="small" ' . selected($size, 'small', false) . '>'.T_('Small').'</option>
                    <option value="medium" ' . selected($size, 'medium', false) . '>'.T_('Medium').'</option>
                    <option value="large" ' . selected($size, 'large', false) . '>'.T_('Large').'</option>
                </select>
                <p class="description">' . 
                    T_('The number of cards per row varies depending on the size and width of the page:') . '<br>
                    <strong>'. T_('Small:') . '</strong>'.T_(' 3 (narrow), 4 (medium), 5 (wide), 6 (full).').'<br>
                    <strong>'.T_('Medium:').'</strong>'.T_(' 2 (narrow), 3 (medium), 4 (wide), 5 (full).').'<br>
                    <strong>'.T_('Large:').'</strong>'.T_(' 2 (narrow), 2 (medium, larger), 3 (wide), 4 (full)'). '
                </p>';
        },
        'zoddak_property_display_page',
        'zoddak_custom_page'
    );

    // === SECCIÓN: Vista de propiedades ===
    add_settings_section(
        'zoddak_property_display_section',
        T_('Customization of the Properties card'),
        null,
        'zoddak_property_display_page'
    );

    add_settings_field(
        'zoddak_border_rounded',
        T_('Card edges'),
        function(){
            $rounded = esc_attr(get_option('zoddak_border_rounded', true));
                        echo '<select name="zoddak_border_rounded">
                                <option value="7px" ' . selected($rounded, '7px', false) . '>'.T_('Rounded').'</option>
                                <option value="0px" ' . selected($rounded, '0px', false) . '>'.T_('Peak').'</option>
                            </select>
                <p class="description">' . T_('Select the shape of the card edges. The selection will affect the edges of the other elements in this plugin for better visual consistency.' ).' </p>';
        },
        'zoddak_property_display_page',
        'zoddak_property_display_section'
    );
    add_settings_field(
        'zoddak_card_bg_color',
        T_('Card background color'),
        function() {
            $color = esc_attr(get_option('zoddak_card_bg_color', '#ffffff'));
            echo '<input type="text" name="zoddak_card_bg_color" value="' . $color . '" class="my-color-field" data-default-color="#ffffff" />';
            echo '<p class="description">'. T_('Select the background color for the property cards.').'</p>';
        },
        'zoddak_property_display_page',
        'zoddak_property_display_section'
    );

    // add_settings_field(
    //     'zoddak_text_size',
    //     'Tamaño del texto',
    //     function() {
    //         $textSize = esc_attr(get_option('zoddak_text_size', '12px'));
    //         echo '<select name="zoddak_text_size">
    //                 <option value="12px" ' . selected($textSize, '12px', false) . '>12px</option>
    //                 <option value="14px" ' . selected($textSize, '14px', false) . '>14px</option>
    //                 <option value="16px" ' . selected($textSize, '16px', false) . '>16px</option>
    //                 <option value="18px" ' . selected($textSize, '18px', false) . '>18px</option>
    //             </select>
    //             <p class="description">Seleccione el tamaño de texto general para las tarjetas.</p>';
    //     },
    //     'zoddak_property_display_page',
    //     'zoddak_property_display_section'
    // );

    add_settings_field(
        'zoddak_color_horizontal_line',
        T_('Color of the horizontal line'),
        function() {
            $colorBtn = esc_attr(get_option('zoddak_color_horizontal_line', '#c61c1c'));
            echo '<input type="text" name="zoddak_color_horizontal_line" value="' . $colorBtn . '" class="my-color-field" data-default-color="#c61c1c" />';
            echo '<p class="description">'. T_('Select the color of the horizontal line.') . '</p>';
        },
        'zoddak_property_display_page',
        'zoddak_property_display_section'
    );
    add_settings_field(
        'zoddak_text_color',
        T_('Card text color'),
        function() {
            $colorBtn = esc_attr(get_option('zoddak_text_color', 'white'));
            echo '<input type="text" name="zoddak_text_color" value="' . $colorBtn . '" class="my-color-field" data-default-color="white" />';
            echo '<p class="description">' . T_('Select the color of the text on the card.') . '</p>';
        },
        'zoddak_property_display_page',
        'zoddak_property_display_section'
    );


    // === SECCIÓN: Botones ===
    add_settings_section(
        'zoddak_settings_display_buttons',
        T_('Button customization'),
        null,
        'zoddak_property_display_page'
    );

    add_settings_field(
        'zoddak_type_property_btn_color',
        T_('Color of the Property reference button'),
        function() {
            $colorBtnType = esc_attr(get_option('zoddak_type_property_btn_color', '#dddd0f'));
            echo '<input type="text" name="zoddak_type_property_btn_color" value="' . $colorBtnType . '" class="my-color-field" data-default-color="#dddd0f" />';
            echo '<p class="description">' . T_('Select the color of the property reference button.') . '</p>';
        },
        'zoddak_property_display_page',
        'zoddak_settings_display_buttons'
    );

    add_settings_field(
        'zoddak_type_property_txt_color',
        T_('Property Type Text Color'),
        function() {
            $colorTxtType = esc_attr(get_option('zoddak_type_property_txt_color', '#ffffff'));
            echo '<input type="text" name="zoddak_type_property_txt_color" value="' . $colorTxtType . '" class="my-color-field" data-default-color="#ffffff" />';
            echo '<p class="description">' . T_('Select the text color for the property type button.') . '</p>';
        },
        'zoddak_property_display_page',
        'zoddak_settings_display_buttons'
    );

    // === SECCIÓN: Paginación ===
    add_settings_section(
        'zoddak_custom_pagination',
        T_('Customization of pagination'),
        null,
        'zoddak_property_display_page'
    );

    // add_settings_field(
    //     'zoddak_hover_color',
    //     'Color de hover de la paginación',
    //     function() {
    //         $colorHover = esc_attr(get_option('zoddak_hover_color', '#110400'));
    //         echo '<input type="text" name="zoddak_hover_color" value="' . $colorHover . '" class="my-color-field" data-default-color="#110400" />';
    //         echo '<p class="description">Seleccione el color del hover de la paginación.</p>';
    //     },
    //     'zoddak_property_display_page',
    //     'zoddak_custom_pagination'
    // );

    add_settings_field(
        'zoddak_current_page_color',
        T_('Color of the current page number'),
        function() {
            $currentPageColor = esc_attr(get_option('zoddak_current_page_color', '#110400'));
            echo '<input type="text" name="zoddak_current_page_color" value="' . $currentPageColor . '" class="my-color-field" data-default-color="#110400" />';
            echo '<p class="description">' . T_('Select the color of the current page number.') . '</p>';
        },
        'zoddak_property_display_page',
        'zoddak_custom_pagination'
    );

    }
    
    public static function registerFilterDisplaySettings() {
        // Registrar las opciones
        register_setting('zoddak_filter_display_group', 'zoddak-bg-color-search-menu');
        register_setting('zoddak_filter_display_group', 'zoddak-btn-color-search-menu');
        register_setting('zoddak_filter_display_group', 'zoddak-reset-btn-color');

        // Crear la sección (ojo: ID distinto del grupo)
        add_settings_section(
            'zoddak_filter_display_section',
            T_('Color customization in the filter'),
            null, 
            'zoddak_filter_display_page'
        );

        // Campo: fondo del menú
        add_settings_field(
            'zoddak-bg-color-search-menu',
            T_('Search menu background color'),
            function() {
                $bgColor = esc_attr(get_option('zoddak-bg-color-search-menu', '#f5f5f5'));
                echo '<input type="text" name="zoddak-bg-color-search-menu" value="' . $bgColor . '" class="my-color-field" data-default-color="#f5f5f5" />';
                echo '<p class="description">' . T_('Select the background color for the search menu.') . '</p>';
            },
            'zoddak_filter_display_page',
            'zoddak_filter_display_section'
        );

        // Campo: botones de búsqueda
        add_settings_field(
            'zoddak-btn-color-search-menu',
            T_('Color of Search and Find Buttons'),
            function() {
                $btnSearch = esc_attr(get_option('zoddak-btn-color-search-menu', '#070100'));
                echo '<input type="text" name="zoddak-btn-color-search-menu" value="' . $btnSearch . '" class="my-color-field" data-default-color="#070100" />';
                echo '<p class="description">' . T_('Choose the color of the search buttons.') . '</p>';
            },
            'zoddak_filter_display_page',
            'zoddak_filter_display_section'
        );

        // Campo: botón de restablecer
        add_settings_field(
            'zoddak-reset-btn-color',
            T_('Reset Button Color'),
            function() {
                $btnColor = esc_attr(get_option('zoddak-reset-btn-color', '#ffffff'));
                echo '<input type="text" name="zoddak-reset-btn-color" value="' . $btnColor . '" class="my-color-field" data-default-color="#ffffff" />';
                echo '<p class="description">' . T_('Select the color of the reset button.') . '</p>';
            },
            'zoddak_filter_display_page',
            'zoddak_filter_display_section'
        );
    }
    public static function customizePropertyDetails() {
        register_setting('zoddak_details_display_group', 'zoddak-btn-price-color');
        register_setting('zoddak_details_display_group', 'zoddak-btn-stage-color');
        register_setting('zoddak_details_display_group', 'zoddak-icons-color');
        register_setting('zoddak_details_display_group', 'zoddak-icons-txt-color');
        add_settings_section(
            'zoddak_property_detail_section',
            T_('Customisation of the property details page'),
            null,
            'zoddak_property_detail_page'
        );
        add_settings_field(
            'zoddak-btn-price-color',
            T_('Colour of the Price button'),
            function() {
                $priceBtnColor = esc_attr(get_option('zoddak-btn-price-color', '#e65638'));
                echo '<input type="text" name="zoddak-btn-price-color" value="' . $priceBtnColor . '" class="my-color-field" data-default-color="#e65638" />';
                echo '<p class="description">' . T_('Select the colour of the price button on the property details page.') . '</p>';
            },
            'zoddak_property_detail_page',
            'zoddak_property_detail_section'
        );
        add_settings_field(
            'zoddak-btn-stage-color',
            T_('Property Status Button Colour'),
            function() {
                $stageBtnColor = esc_attr(get_option('zoddak-btn-stage-color', '#dddd0f'));
                echo '<input type="text" name="zoddak-btn-stage-color" value="' . $stageBtnColor . '" class="my-color-field" data-default-color="#dddd0f" />';
                echo '<p class="description">' . T_('Select the colour of the status button on the property details page.') . '</p>';
            },
            'zoddak_property_detail_page',
            'zoddak_property_detail_section'
        );
        add_settings_field(
            'zoddak-icons-color',
            T_('Feature background colour'),
            function() {
                $iconsColor = esc_attr(get_option('zoddak-icons-color', '#e97c61'));
                echo '<input type="text" name="zoddak-icons-color" value="' . $iconsColor . '" class="my-color-field" data-default-color="#e97c61" />';
                echo '<p class="description">' . T_('Select the background colour for the features on the property details page.') . '</p>';
            },
            'zoddak_property_detail_page',
            'zoddak_property_detail_section'
        );
        add_settings_field(
            'zoddak-icons-txt-color',
            T_('Feature color'),
            function() {
                $iconsTxtColor = esc_attr(get_option('zoddak-icons-txt-color', '#000000'));
                echo '<input type="text" name="zoddak-icons-txt-color" value="' . $iconsTxtColor . '" class="my-color-field" data-default-color="#000000" />';
                echo '<p class="description">' . T_('Select the color of the features on the property details page.') . '</p>';
            },
            'zoddak_property_detail_page',
            'zoddak_property_detail_section'
        );
    }
   public static function newDevsSettings()
    {
        register_setting('zoddak_newdevs_settings_group', 'zoddak_newdevs_location');
        register_setting('zoddak_newdevs_settings_group', 'zoddak_newdevs_price_range');
        register_setting('zoddak_newdevs_settings_group', 'zoddak_newdevs_stages');
        register_setting('zoddak_newdevs_settings_group', 'zoddak_newdevs_types');
        register_setting('zoddak_newdevs_settings_group', 'zoddak_newdevs_contact_users');
        register_setting('zoddak_newdevs_settings_group', 'zoddak_featured_developments');
        add_settings_section(
            'zoddak_newdevs_admin_section',
            'Ajustes de página',
            null, 
            'zoddak_newdevs_settings'
        );

        add_settings_field(
            'zoddak_newdevs_location',
            T_('Areas to hide'),
            function() {
                $selectedLocations = get_option('zoddak_newdevs_location', []); // ← array
                if (!is_array($selectedLocations)) {
                    $selectedLocations = [$selectedLocations];
                }

                $locations = ApiController::get_areas();
                echo '<select multiple name="zoddak_newdevs_location[]" id="zoddak_newdevs_location" style="min-width: 250px; height: 150px;">';
                echo '<option value="">' . T_('Select one or more locations (Ctrl + clic)') . '</option>';

                foreach ($locations as $loc) {  
                    $name = esc_html($loc['town'] ?? '');
                    if ($name) {
                        $selected = in_array($name, $selectedLocations) ? 'selected' : '';
                        echo '<option value="' . $name . '" ' . $selected . '>' . $name . '</option>';
                    }
                }

                echo '</select>';
                echo '<p class="description">' . T_('Select the areas you do not want to display on your page.') . '</p>';
            },
            'zoddak_newdevs_settings',       
            'zoddak_newdevs_admin_section'   
        );
        add_settings_field(
            'zoddak_newdevs_price_range',
            T_('Rango de precio'),
            function() {
                $priceRange = get_option('zoddak_newdevs_price_range', ['min' => 0, 'max' => 35000000]);
                $min = esc_attr((int)$priceRange['min']);
                $max = esc_attr($priceRange['max']);
            
               echo '<div class="price-range-wrapper">
                    <div class="price-values">
                        <span id="minPriceLabel">€ ' . number_format($min, 0, ',', '.') . '</span>
                        <span id="maxPriceLabel">€ ' . number_format($max, 0, ',', '.') . '</span>
                    </div>
                    <div class="slider-track"></div>
                    <input type="range" id="minPrice" name="zoddak_newdevs_price_range[min]" step=150000 min="0" max="35000000" step="1000" value="'. $min .'">
                    <input type="range" id="maxPrice" name="zoddak_newdevs_price_range[max]" step=150000 min="0" max="35000000" step="1000" value="'. $max .'">
                    
                    <p class="description">' . T_('Select the price range you wish to display.') . ' </p>
                </div>';
            },
            'zoddak_newdevs_settings',
            'zoddak_newdevs_admin_section'
        );
        add_settings_field(
            'zoddak_newdevs_stages',
            T_('Stages'),
            function() {
                $stages = ApiController::get_property_stage();

                $selectedStages = get_option('zoddak_newdevs_stages', []);
                if (!is_array($selectedStages)) {
                    $selectedStages = [$selectedStages];
                }   
                $lang = strtolower( substr( get_locale(), 0, 2 ) );
                echo '<select multiple name="zoddak_newdevs_stages[]" id="zoddak_newdevs_stages" style="min-width:250px; height:150px;">';
                echo '<option value="">'. T_('Select one or more states to hide') . '(Ctrl + click)</option>';
                if (!empty($stages) && is_array($stages)) {
                    foreach ($stages as $stage) {
                        $name = esc_html($stage[$lang] ?? '');
                        if ($name) {
                            $selected = in_array($name, $selectedStages) ? 'selected' : '';
                            echo '<option value="' . $name . '" ' . $selected . '>' . $name . '</option>';
                        }
                    }
                } else {
                    echo '<option value="">' . T_('No stages found') . '</option>';
                }

                echo '</select>';
                echo '<p class="description">' . T_('Select the stages you wish to hide on your page.'). '</p>';
            },
            'zoddak_newdevs_settings',
            'zoddak_newdevs_admin_section'
        );
        add_settings_field(
            'zoddak_newdevs_types',
            'Tipos',
            function () {
                $selectedTypes = get_option('zoddak_newdevs_types', []);
                if (!is_array($selectedTypes)) {
                    $selectedTypes = [$selectedTypes];
                }

                $types = [
                    'Apartments',
                    'Villas',
                    'Townhouses'
                ];

                echo '<select multiple name="zoddak_newdevs_types[]" id="zoddak_newdevs_types" style="min-width:250px; height:150px;">';
                echo '<option value="">'. T_('Select one or more types to hide') . '(Ctrl + clic)</option>';

                foreach ($types as $type) {
                    $value = strtolower($type);
                    $selected = in_array($value, $selectedTypes) ? 'selected' : '';
                    echo '<option value="' . esc_attr($value) . '" ' . $selected . '>' . esc_html($type) . '</option>';
                }

                echo '</select>';
                echo '<p class="description">' . T_('Select the property types you do not want to display on your page.') . '</p>';
            },
            'zoddak_newdevs_settings',
            'zoddak_newdevs_admin_section'
        );
        // add_settings_field(
        //     'zoddak_newdevs_contact_users',
        //     T_('Users to contact'),
        //     function() {
        //         $selectedUsers = get_option('zoddak_newdevs_contact_users', []);
        //         $users = get_users();
        //         echo '<select multiple name="zoddak_newdevs_contact_users[]" id="zoddak_newdevs_contact_users" style="min-width:250px; height:150px;">';
        //         echo '<option value="">' . T_('Select one or more users to receive contact form submissions (Ctrl + click)') . '</option>';
        //         foreach ($users as $user) {
        //             $displayName = esc_html($user->display_name);
        //             $userEmail = esc_html($user->user_email);
        //             $selected = in_array($userEmail, $selectedUsers) ? 'selected' : '';
        //             echo '<option value="' . $userEmail . '" ' . $selected . '>' . $displayName . ' - ' . $userEmail . '</option>';
        //         }
        //         echo '</select>';
        //         echo '<p class="description">' . T_('Select the users who will receive the contact form submissions.') . '</p>';
        //     },
        //     'zoddak_newdevs_settings',
        //     'zoddak_newdevs_admin_section'
        // );
    }

}
