const lat = document.getElementById('property-map').getAttribute('data-lat');
const lng = document.getElementById('property-map').getAttribute('data-lng');
const radius = 750; // radio en metros
document.addEventListener('DOMContentLoaded', function(){
    const map = L.map('property-map').setView([lat,lng], 15);
    L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
        attribution: '&copy; OpenStreetMap contributors'
    }).addTo(map);
        // Dibuja el círculo con radio
    const circle = L.circle([lat, lng], {
        color: '#d9534f',      // borde
        fillColor: '#f03',     // relleno
        fillOpacity: 0.3,
        radius: radius           // radio en metros (ajústalo según necesidad)
    }).addTo(map);

const visibleThumbs = 12;
const thumbsSwiper = new Swiper(".thumbs-swiper", {
    slidesPerView: visibleThumbs,
    spaceBetween: 10,
    watchSlidesProgress: true,
    slideToClickedSlide: true,
});

const mainSwiper = new Swiper(".main-swiper", {
    spaceBetween: 10,
    navigation: { nextEl: ".swiper-button-next", prevEl: ".swiper-button-prev" },
    effect: "fade",
    fadeEffect: { crossFade: true },
    thumbs: { swiper: thumbsSwiper },
    on: {
        slideChange() {
            const activeIndex = this.activeIndex;
            console.log(activeIndex);
            const thumbs = thumbsSwiper;
            console.log(thumbs);
            // Asegura que la miniatura activa esté visible
            if (activeIndex < thumbs.activeIndex || activeIndex >= thumbs.activeIndex + visibleThumbs) {
                thumbs.slideTo(activeIndex);
            }

            // Marca visualmente la miniatura activa
            thumbs.slides.forEach((slide, i) => {
                slide.classList.toggle('thumb-active', i === activeIndex);
            });
        },
    },
});

// Marca inicialmente la primera miniatura como activa
thumbsSwiper.slides[0]?.classList.add('thumb-active');
  document.querySelectorAll(".box-outter").forEach(header => {
    header.addEventListener("click", () => {
      header.classList.toggle("active");
      const collapse = header.nextElementSibling;

      if (header.classList.contains("active")) {
        collapse.style.maxHeight = collapse.scrollHeight + "px";
        collapse.style.opacity = "1";
      } else {
        collapse.style.maxHeight = "0";
        collapse.style.opacity = "0";
      }
    });
  });


})