jQuery(document).ready(function($){
    $('#zoddak_newdevs_location, #zoddak_newdevs_stages, #zoddak_newdevs_types, #zoddak_newdevs_contact_users').select2({
        placeholder: 'Seleccione una o más opciones',
        allowClear: true,
        width: '100%'
    })
      const minInput = $('#minPrice');
  const maxInput = $('#maxPrice');
  const minLabel = $('#minPriceLabel');
  const maxLabel = $('#maxPriceLabel');
  const track = $('.slider-track')[0];

  const MAX = parseInt(maxInput.attr('max'), 10);
  const STEP = parseInt(minInput.attr('step'), 10);
  const GAP = STEP; // que el mínimo gap sea igual al salto (100.000 €)

  function fmt(n){ return n.toLocaleString('es-ES'); }

  function paintTrack(minVal, maxVal){
    const p1 = (minVal / MAX) * 100;
    const p2 = (maxVal / MAX) * 100;
    if(!track) return;
    track.style.background =
      `linear-gradient(to right, #ccc ${p1}%, #d000b7 ${p1}%, #d000b7 ${p2}%, #ccc ${p2}%)`;
  }

  function update(){
    let minVal = Math.round(parseInt(minInput.val(), 10) / STEP) * STEP;
    let maxVal = Math.round(parseInt(maxInput.val(), 10) / STEP) * STEP;

    if (maxVal - minVal < GAP){
      if (document.activeElement === minInput[0]) minVal = maxVal - GAP;
      else maxVal = minVal + GAP;
    }

    minInput.val(minVal);
    maxInput.val(maxVal);

    // z-index dinámico para evitar solapamiento
    minInput.css('z-index', minVal >= maxVal - GAP ? 5 : 3);
    maxInput.css('z-index', minVal >= maxVal - GAP ? 4 : 2);

    minLabel.text('€' + fmt(minVal));
    maxLabel.text('€' + fmt(maxVal));
    paintTrack(minVal, maxVal);
  }

  minInput.on('input', update);
  maxInput.on('input', update);
  update();
})