jQuery(document).ready(function($) {

    const cardBgInput = $('input[name="zoddak_card_bg_color"]');
    const lineColorInput = $('input[name="zoddak_color_horizontal_line"]');
    const btnRefProperty = $('input[name="zoddak_type_property_btn_color"]');
    const textColor = $('input[name="zoddak_text_color"]');
    const txtTypeProperty = $('input[name="zoddak_type_property_txt_color"]');
    const colorHoverPagination = $('input[name="zoddak_hover_color"]');
    const badgeRef = $('#propRef');
    const badgeRefLayout = $('.prop-ref'); 
    const stageBadge = $('.stage-badge');
    const colorNUmberPagination = $('input[name="zoddak_current_page_color"]');
    const borderRadius = $('select[name="zoddak_border_rounded"]');
    const widthPage  = $('select[name="zoddak_page_width"]');
    const card = $('.card-preview');
    const screenPreview = $('.screen-preview');
    const exampleCard = $('.example-card');
    borderRadius.on('change', function(){
        card.css('border-radius', borderRadius.val());
        exampleCard.css('border-radius', borderRadius.val())
        badgeRef.css('border-radius', borderRadius.val());
        badgeRefLayout.css('border-radius', borderRadius.val());
        stageBadge.css('border-radius', borderRadius.val());
    })
    console.log(card);
    cardBgInput.wpColorPicker({
        change: function(event, ui) {
            const color = ui.color.toString();
            card.css('background-color', color);
        },
        clear: function() {
            card.css('background-color', '');
        }
    });

    textColor.wpColorPicker({
        change: function(event, ui){
            const color = ui.color.toString();
            $('.card-preview').css('color', color);
        },
        clear: function(event, ui){
            $('.card-preview').css('color', '');
        }
    })

    lineColorInput.wpColorPicker({
        change: function(event, ui) {
            const color = ui.color.toString();
            document.documentElement.style.setProperty('--line-hor', color);
        },
        clear: function() {
            document.documentElement.style.setProperty('--line-hor');
        }
    });

    btnRefProperty.wpColorPicker({
        change: function(event, ui){
            const color = ui.color.toString();
            $('#propRef').css('background-color', color);
        },
        clear: function () {
            $('#propRef').css('background-color', '');
        }
    })

    txtTypeProperty.wpColorPicker({
        change: function(event, ui){
            const color = ui.color.toString();
            $('#propRef').css('color', color);
        },
        clear: function () {
            $('#propRef').css('color', '');
        }
    })
    colorNUmberPagination.wpColorPicker({
        change: function(event, ui){
            const color = ui.color.toString();
            $('.pagination.current').css('background-color', color);
        },
        clear: function () {
            $('.pagination.current').css('background-color', '');
        }
    })


    const previewCard = $('.card-preview');
    const previewImg = previewCard.find('.zoddak-preview-image');

    $('select[name="zoddak_text_size"]').on('change', function() {
        previewCard.css('font-size', $(this).val());
    });


    $('select[name="zoddak_property_layout"]').on('change', function() {
        const layout = $(this).val();
        previewCard.removeClass('horizontal vertical').addClass(layout);
        exampleCard.removeClass('horizontal vertical').addClass(layout);
    });

    const currentLayout = $('select[name="zoddak_property_layout"]').val();
    previewCard.addClass(currentLayout);
    exampleCard.addClass(currentLayout);
    $('select[name="zoddak_card_size"]').on('change', function() {
        const size = $(this).val();
        if(size === 'small'){
            previewCard.removeClass('medium');
            previewCard.removeClass('large');
            previewCard.addClass('small');
            exampleCard.removeClass('medium');
            exampleCard.removeClass('large');
            exampleCard.addClass('small');
        }else if(size === 'medium'){
            previewCard.removeClass('small');
            previewCard.removeClass('large');
            previewCard.addClass('medium');
            exampleCard.removeClass('small');
            exampleCard.removeClass('large');
            exampleCard.addClass('medium');        
        }else if(size === 'large'){
            previewCard.removeClass('small');
            previewCard.removeClass('medium');
            previewCard.addClass('large');  
            exampleCard.removeClass('small');
            exampleCard.removeClass('medium');
            exampleCard.addClass('large');
        }
    });

    $('select[name="zoddak_card_size"]').trigger('change');
    function applyInitialPreview() {
        const cardBg = cardBgInput.val();
        const btnTypeColor = btnRefProperty.val();
        const txtTypeColor = txtTypeProperty.val();
        const hoverColor = colorHoverPagination.val();
        const numberColor = colorNUmberPagination.val();

        if (cardBg) $('.card-preview').css('background-color', cardBg);
        if (btnTypeColor) $('#typeProp').css('background-color', btnTypeColor);
        if (txtTypeColor) $('#typeProp').css('color', txtTypeColor);
        if (numberColor) $('.pagination').css('color', numberColor);
        if (hoverColor) updateHoverPreview(hoverColor);
    }
    widthPage.on('change', function() {
        const width = $(this).val();
        if(width === '1400px'){
            screenPreview.addClass('large');
            screenPreview.removeClass('medium');
            screenPreview.removeClass('small');
            screenPreview.removeClass('total');
        }else if(width === '1200px'){
            screenPreview.addClass('medium');
            screenPreview.removeClass('large');
            screenPreview.removeClass('small');
            screenPreview.removeClass('total');
        }else if(width === '960px'){
            screenPreview.addClass('small');
            screenPreview.removeClass('medium');
            screenPreview.removeClass('large');
            screenPreview.removeClass('total');
        }else if(width === '100%'){
            screenPreview.addClass('total');
            screenPreview.removeClass('small');
            screenPreview.removeClass('medium');
            screenPreview.removeClass('large');
        }
    })
    widthPage.trigger('change');
    applyInitialPreview();
    const toggleView = document.getElementById('toggleView');
    const pagePreview = document.querySelector('.page-preview');
    const pageLayout = document.querySelector('.page-layout');

    toggleView.addEventListener('change', () => {
        if (toggleView.checked) {
            pagePreview.classList.add('hidden');
            pageLayout.classList.add('active');
        } else {
            pageLayout.classList.remove('active');
            pagePreview.classList.remove('hidden');
        }
    });

    const layoutSelect = document.querySelector("[name='zoddak_property_layout']");
    const sizeSelect = document.querySelector("[name='zoddak_card_size']");
    [...layoutSelect.options].forEach(layout => {
        if(layout.value === 'horizontal' && layout.selected === true){
            [...sizeSelect.options].forEach(opt => {
                if(opt.value === 'small'){
                    opt.style.display = 'none';
                }else{
                    opt.style.display = 'block'
                }
            })
        }
    })
    layoutSelect.addEventListener('click', function() {
        const element = this.value
        if(element === 'horizontal'){
            [...sizeSelect.options].forEach(opt => {
                if(opt.value === 'small'){
                    opt.style.display = 'none';
                }else{
                    opt.style.display = 'block';
                }
            });
            if (sizeSelect.value === 'small') {
                const firstVisible = [...sizeSelect.options].find(opt => opt.style.display !== 'none');
                if (firstVisible) sizeSelect.value = firstVisible.value;
            }
        }else{
            [...sizeSelect.options].forEach(opt => {
                opt.style.display = 'block'
            })
        }
    })
});
