Modificado (1/12/2025)
# Zoddak New Developments Connector

A professional WordPress plugin that integrates your website with the Zoddak platform to display real-estate **New Developments** using a fully responsive, customizable and API-driven system.  
Includes advanced filtering, dynamic layouts, color customization, contact form integration and a dedicated admin panel for total control.

---

## 🚀 Overview

Zoddak New Developments Connector enables developers and agencies to embed high-quality property development listings directly into any WordPress site.  
All data is imported in real time from Zoddak’s API, and the plugin offers extensive customization options to match the branding and functional needs of each agency.

---

## ✨ Key Features

### 🔹 **API Integration**
- Direct connection with the official Zoddak API
- Real-time property updates
- Secure requests restricted via public IP whitelist

### 🔹 **Fully Responsive UI**
- Modern, professional card-based layout
- Full compatibility with desktop, tablet and mobile

### 🔹 **Advanced Filters**
Users can filter developments by:
- Price  
- Area (sqm)  
- Bedrooms  
- Property type  
- Development status (off-plan, with license, etc.)

Sorting options available:
- Price: High → Low  
- Price: Low → High  

### 🔹 **Contact Integration (via Contact Form 7)**
- Contact button included inside each development
- Emails fully customizable with an HTML template
- Works with any CF7 form (shortcode added in plugin settings)

### 🔹 **Customization Options (Unique Feature)**
The plugin allows agencies to fully customize the visual presentation of their developments:

- Card layout:
  - **Vertical mode**
  - **Horizontal mode**

- Card size:
  - Small  
  - Medium  
  - Large  

- Colors:
  - Primary accent color  
  - Text and background emphasis  
  - Button color and hover states  

All changes are instantly reflected on the front-end.

### 🔹 **Admin Control Panel**
Agencies can manage the behavior of the New Developments page through a dedicated settings panel:

- Select which **areas** to hide or show  
- Select which **development statuses** to hide or show  
- Select which **property types** to hide or show  
- Define **minimum and maximum price ranges** to display  

Perfect for agencies that want to fine-tune what appears on their website.

---

## 📦 Requirements

### 1. **Contact Form 7**
The plugin depends on Contact Form 7.  
You must install and activate it before configuring the Zoddak plugin.

### 2. **A Contact Form for Lead Capture**
Inside Contact Form 7:
- Create a new form
- Set the email recipient(s)
- Copy and paste the **required HTML email template** (see below)
- Copy the form’s **shortcode** and paste it into the Zoddak plugin settings page

### 3. **Zoddak API Token**
An API token is generated automatically when the agency purchases the WordPress service.  
It appears under **My Services** on the Zoddak platform.

### 4. **Public IP Whitelist**
You must add your server’s **public IP** under the API Token configuration.  
If the IP is not whitelisted, API requests will be blocked.

---
## 📧 Required Email Template (HTML)

Paste this entire template in the **Message Body** of your CF7 form:

```html
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <style>
    body {
      font-family: Arial, sans-serif;
      color: #333;
      background-color: #f9f9f9;
      padding: 20px;
    }
    .container {
      background-color: #ffffff;
      border: 1px solid #ddd;
      border-radius: 8px;
      padding: 20px;
      max-width: 600px;
      margin: auto;
      box-shadow: 0 2px 5px rgba(0,0,0,0.1);
    }
    h2 {
      color: #2eb79d;
      margin-bottom: 10px;
    }
    h3 {
      color: #444;
      margin-top: 25px;
      margin-bottom: 10px;
      border-bottom: 1px solid #ddd;
      padding-bottom: 5px;
    }
    .label {
      font-weight: bold;
    }
    .footer {
      font-size: 0.9em;
      color: #555;
      margin-top: 30px;
    }
    a {
      color: #2eb79d;
      text-decoration: none;
    }
    a:hover {
      text-decoration: underline;
    }
  </style>
</head>
<body>
  <div class="container">
    <h2>New Contact Form Submission</h2>

    <h3>Client Information</h3>
    <p><span class="label">Name:</span> [your-name]</p>
    <p><span class="label">Email:</span> <a href="mailto:[your-email]">[your-email]</a></p>
    <p><span class="label">Phone number:</span> [tel]</p>

    <h3>Message</h3>
    <p><span class="label">Subject:</span> [your-subject]</p>
    <p><span class="label">Message:</span><br>[your-message]</p>

    <h3>Submission Details</h3>
    <p><span class="label">Submitted from:</span> 
      <a href="[_url]" target="_blank" rel="noopener noreferrer">[_url]</a>
    </p>
    <p><span class="label">Date of submission:</span> [_date]</p>

    <div class="footer">
      --<br>
      This notification was automatically generated from your website 
      (<strong>[_site_title]</strong>, 
      <a href="[_site_url]" target="_blank" rel="noopener noreferrer">[_site_url]</a>).
    </div>
  </div>
</body>
</html>
```

## 🔧 How to Use

### **Step 1 – Get Your API Token**
- Log in to **Zoddak**
- Go to **My Services**
- Copy your **WordPress integration token**

---

### **Step 2 – Add Your Public IP**
Add your server’s **public IP address** to the whitelist under your API token.

---

### **Step 3 – Install Required Plugins**
Install and activate:

- **Zoddak New Developments Connector**
- **Contact Form 7**

---

### **Step 4 – Create Your Contact Form**
In Contact Form 7:

- Create a new form  
- Insert the **HTML email template** provided by Zoddak  
- Copy the form’s **shortcode**

---

### **Step 5 – Configure the Plugin**
Inside the **Zoddak plugin admin panel**, you must:

- Paste your **API token**
- Paste your **CF7 shortcode**
- Choose your **custom route** (the URL where the New Developments page will be displayed)
- Configure:
  - Filters  
  - Exclusions (areas, statuses, property types)  
  - Price range  
- Customize:
  - Card layout (vertical/horizontal)  
  - Card size (small/medium/large)  
  - Colors

---

### **Step 6 – Visit Your Route**
Open your configured **custom route URL** in your browser.  
You should now see your fully functional New Developments page.

---

## 🧩 Shortcodes

The plugin uses **your own Contact Form 7 shortcode**, for example:

[contact-form-7 id="123" title="Zoddak Contact Form"]

You simply paste it inside the plugin settings.
